#include "ext.h"
#include "z_dsp.h"
// the lp1 object. A low pass controllable with freq and res

void *lp1_class;

typedef struct _lp1
{
	t_pxobject l_obj;
	float l_freq;
	float l_r;
	float l_a1;
	float l_a2;
	float l_ym1;
	float l_ym2;
	float l_xm1;
	float l_fqterm;
	float l_2pidsr;
	short l_rcon;
	short l_fcon;
} t_lp1;

t_int *lp1_perform(t_int *w);
void lp1_dsp(t_lp1 *x, t_signal **sp, short *count);
void lp1_float(t_lp1 *x, double f);
void lp1_calc(t_lp1 *x);
void lp1_clear(t_lp1 *x);
void *lp1_new(double freq, double reso);
void lp1_assist(t_lp1 *x, void *b, long m, long a, char *s);

int errno;

int main(void)
{
	setup((t_messlist **)&lp1_class, (method)lp1_new, (method)dsp_free, 
		sizeof(t_lp1), 0L, A_DEFFLOAT, A_DEFFLOAT, 0);
	addmess((method)lp1_dsp, "dsp", A_CANT, 0);
	addmess((method)lp1_assist, "assist", A_CANT, 0);
	addmess((method)lp1_clear, "clear", 0);
	addfloat((method)lp1_float);
	dsp_initclass();
	return (0);
}


void lp1_assist(t_lp1 *x, void *b, long m, long a, char *s)
{
//	assist_string(3325,m,a,1,4,s);
}

t_int *lp1_perform(t_int *w)
{

    t_float *in = (t_float *)(w[1]);
    t_float *out = (t_float *)(w[2]);
    t_lp1 *x = (t_lp1 *)(w[3]);
   t_float freq = x->l_fcon ? *(float *)(w[4]) : x->l_freq;
    t_float resonance = x->l_rcon ? *(float *)(w[5]) : x->l_r;
    int n = (int)(w[6]);
   double a1 = x->l_a1;
   float a2 = x->l_a2, ym1 = x->l_ym1, ym2 = x->l_ym2, xm1 = x->l_xm1;

    double val, scale;

    if (resonance >= 1.)
    	resonance = 1. - 1E-20;

    if (freq != x->l_freq || resonance != x->l_r) {
    	if (freq != x->l_freq)
    		x->l_fqterm = cos(x->l_2pidsr * freq);
    	x->l_a1 = a1 = -2. * resonance * x->l_fqterm;
    	x->l_a2 = a2 = resonance * resonance;
    	x->l_r = resonance;
    	x->l_freq = freq;
    }

  scale = 1. + a1 + a2;

    while (--n)
    {
    	val = *++in;
    	ym1 = scale * xm1 - a1 * ym1 - a2 * ym2;
    	ym2 = ym1;
    	xm1 = val;
    	*++out = ym1;
    }
    x->l_ym1 = ym1;
    x->l_ym2 = ym2;
    x->l_xm1 = xm1;

    return (w + 7);
}

void lp1_dsp(t_lp1 *x, t_signal **sp, short *count)
{
	x->l_2pidsr = (2. * PI) / sp[0]->s_sr;
	lp1_calc(x);
	x->l_fcon = count[1];
	x->l_rcon = count[2];
	lp1_clear(x);
	dsp_add(lp1_perform, 6, sp[0]->s_vec-1, sp[3]->s_vec-1, x, 
		sp[1]->s_vec, sp[2]->s_vec, sp[0]->s_n+1);
}

void lp1_float(t_lp1 *x, double f)
{
	
	if (x->l_obj.z_in == 1) {
		x->l_freq = f;
		lp1_calc(x);
	} else if (x->l_obj.z_in == 2) {
		x->l_r = f >= 1.0 ? 1 - 1E-20 : f;
		lp1_calc(x);
	}
}

void lp1_clear(t_lp1 *x)
{
	x->l_ym1 = x->l_ym2 = x->l_xm1 = 0.;
}

void lp1_calc(t_lp1 *x)
{
	x->l_fqterm = cos(x->l_2pidsr * x->l_freq);
	x->l_a1 = -2. * x->l_r * x->l_fqterm;
	x->l_a2 = x->l_r * x->l_r;
}

void *lp1_new(double val, double reso)
{
    t_lp1 *x = (t_lp1 *)newobject(lp1_class);
    dsp_setup((t_pxobject *)x,3);
    x->l_freq = val;
    x->l_r = reso >= 1.0 ? 1. - 1E-20 : reso;
    x->l_2pidsr = (2. * PI) / sys_getsr();
    lp1_calc(x);
    outlet_new((t_object *)x, "signal");
    return (x);
}
