/* snap~.c  
** broken version
** 05/12/04 IF Xcode
*/

#include "ext.h"    // Required for all Max external objects
#include "z_dsp.h"  // Required for all MSP external objects

void *snap_class;

typedef struct _snap 	// Data structure for this object
{
    t_pxobject t_obj;
    t_int t_clock;
    t_int t_interval_msec;
	t_int t_interval_sample;
    t_float t_current_value;
	t_int t_current_sample;
	t_int t_offset;
    t_int t_bang;
    t_float t_sr;
    void *t_outlet;
    void *qe;
} t_snap;

void *snap_new(int interval, int sample);
t_int *snap_perform(t_int *w);
void snap_dsp(t_snap *x, t_signal **sp, short *count);
void snap_bang(t_snap *x);
void snap_out(t_snap *x);
void snap_offset(t_snap *x, t_int offset);
void snap_interval(t_snap *x, t_int interval);
void snap_int(t_snap *x, t_int on);
void snap_float(t_snap *x, t_float on);
void snap_out(t_snap *x);

int main(void)
{
    setup((t_messlist **)&snap_class, (method)snap_new, (method)dsp_free, 
    	(short)sizeof(t_snap), 0L, A_DEFLONG, A_DEFLONG, 0);
    addmess((method)snap_dsp, "dsp", A_CANT, 0);
    dsp_initclass();
	return(0);
}


void *snap_new(int interval, int offset)
{
	t_snap *x = (t_snap *)newobject(snap_class);

	x->t_clock = 1;
	x->t_current_value = 0;
	x->t_interval_msec = interval;
	x->t_offset = offset;
	x->t_current_sample = 0;
    x->t_outlet = floatout(x);
	dsp_setup((t_pxobject *)x, 1);			
	return (x);
}

	
void snap_dsp(t_snap *x, t_signal **sp, short *count)
{
    x->t_interval_sample =  x->t_interval_msec * sp[0]->s_sr / 1000;
	dsp_add(snap_perform, 3, sp[0]->s_vec, sp[0]->s_n, x);
}


t_int *snap_perform(t_int *w)
{
    t_float *in = (t_float *)(w[1]);
 	t_int n = (t_int)(w[2]);
 	t_snap *x = (t_snap *)(w[3]);
 
	while (n--)
	{
		if	(x->t_current_sample == 0)
		{
		    x->t_current_value = in[x->t_offset];
		    outlet_float(x->t_outlet, x->t_current_value);
		}
		if (x->t_current_sample++ >= x->t_interval_sample)
		  x->t_current_sample = 0;
	}		
    return (w + 4);
}
