/* iter.c -- sequential list unpacking ------- */

#include "ext.h"
#include "ext_common.h"  // for MIN() macro

#define MAXSIZE 256

typedef struct iter {
	t_object i_ob;
	t_atom i_av[MAXSIZE];
	short i_ac; // number of elements in i_av
} t_iter;

void *iter_class;

void iter_int(t_iter *x, long n);
void iter_float(t_iter *x, double f);
void iter_bang(t_iter *x);
void iter_list(t_iter *x, t_symbol *s, short ac, t_atom *av);
void iter_anything(t_iter *x, t_symbol *s, short ac, t_atom *av);
void *iter_new(long dummy);

int main()
{
	setup((t_messlist **)&iter_class, (method)iter_new,0L, (short)sizeof(t_iter), 0L, A_DEFLONG, 0);
	addint((method)iter_int);
	addbang((method)iter_bang);
	addmess((method)iter_list,"list", A_GIMME, 0);
	addmess((method)iter_anything,"anything",A_GIMME, 0);
	addfloat((method)iter_float);
	finder_addclass("Lists","iterate");
	return(0);
}

void iter_int(t_iter *x, long n)
{
	x->i_ac = 1;
	SETLONG(x->i_av,n);
	outlet_int(x->i_ob.o_outlet,n);
}

void iter_float(t_iter *x, double f)
{
	x->i_ac = 1;
	SETFLOAT(x->i_av,f);
	outlet_float(x->i_ob.o_outlet,f);
}

void iter_bang(t_iter *x)
{
	short i;
	t_atom *av;
//post("BANG");		
	for (i = 0, av = x->i_av; i < x->i_ac; i++, av++) {
		if (av->a_type == A_LONG)
			outlet_int(x->i_ob.o_outlet, av->a_w.w_long);
		else if (av->a_type == A_FLOAT)
			outlet_float(x->i_ob.o_outlet, av->a_w.w_float);
		else if (av->a_type == A_SYM)
			outlet_anything(x->i_ob.o_outlet, av->a_w.w_sym, 0, 0);
	}
}

void iter_list(t_iter *x, Symbol *s, short ac, Atom *av)
{
	short i;
post("LIST");				
	ac = MIN(ac, MAXSIZE);
	for (i = 0; i < ac; i++, av++) {
		x->i_av[i] = *av;
		if (av->a_type == A_LONG)
			outlet_int(x->i_ob.o_outlet, av->a_w.w_long);
		else if (av->a_type == A_FLOAT)
			outlet_float(x->i_ob.o_outlet, av->a_w.w_float);
		else if (av->a_type == A_SYM)
			outlet_anything(x->i_ob.o_outlet, av->a_w.w_sym, 0, 0);
	}
	x->i_ac = ac;
}

void iter_anything(t_iter *x, Symbol *s, short ac, Atom *av)
{
	short i;
post("ANYTHING");				
}

void *iter_new(long dummy)
{
	t_iter *x;
	short i;
	
	x = (t_iter *)newobject(iter_class);
	x->i_ac = 0;
	for (i = 0; i < MAXSIZE; i++)
		SETLONG(x->i_av + i, 0);
	outlet_new(x, 0L);
	return x;
}			
