/* thrugai2n~.c two signal/float inlet, two signal outlets, one float outlet
** 
** 02/11/05 IF
*/
#include "ext.h"    // Required for all Max external objects
#include "z_dsp.h"  // Required for all MSP external objects

void *thrugain_class;

typedef struct _thrugain 	// Data structure for this object
{
    t_pxobject t_obj;
    t_float t_gain;
    void *t_out;		// float outlet
} t_thrugain;

void *thrugain_new(void);
t_int *thrugain_perform(t_int *w);
void thrugain_dsp(t_thrugain *x, t_signal **sp, short *count);
void thrugain_float(t_thrugain *x, t_float val);
void thrugain_bang(t_thrugain *x);

int main(void)
{
    setup((t_messlist **)&thrugain_class, (method)thrugain_new, (method)dsp_free, (short)sizeof(t_thrugain), 0L, 0);
    addmess((method)thrugain_dsp, "dsp", A_CANT, 0);
    addfloat((method)thrugain_float);		
    addbang((method)thrugain_bang);		
    dsp_initclass();
	return(0);
}

void *thrugain_new(void)
{
	t_thrugain *x = (t_thrugain *)newobject(thrugain_class);
	x->t_gain = 1.0;
	dsp_setup((t_pxobject *)x, 2);			// left signal inlet
	x->t_out = floatout((t_pxobject *)x);	// right float outlet
	outlet_new((t_pxobject *)x, "signal");	// middle signal outlet, must come after floatout
	outlet_new((t_pxobject *)x, "signal");	// left signal outlet, must come after floatout
	return (x);
}

void thrugain_float(t_thrugain *x, t_float val)
{
	post("Float in: %f", val);
	x->t_gain = val;
	outlet_float(x->t_out, x->t_gain);
}

void thrugain_bang(t_thrugain *x)
{
	post("Bang");
	outlet_float(x->t_out, x->t_gain);
}

void thrugain_dsp(t_thrugain *x, t_signal **sp, short *count)
{
	dsp_add(thrugain_perform, 6, sp[0]->s_vec, sp[1]->s_vec, sp[2]->s_vec, sp[3]->s_vec, sp[0]->s_n, x);
}


t_int *thrugain_perform(t_int *w)
{
    t_float *inL = (t_float *)(w[1]);
    t_float *inR = (t_float *)(w[2]);
    t_float *outR = (t_float *)(w[3]);
    t_float *outL = (t_float *)(w[4]);
	int n = (int)(w[5]);
	t_thrugain *x = (t_thrugain *)w[6];

	while (n--) 
	{
		*outL++ = x->t_gain * *inL++; 
		*outR++ = x->t_gain * *inR++;
	}
		
    return (w + 7); // always add one more than the 2nd argument in dsp_add()
}



