/*	thru.c -- 03/09/20 Multiple inlets and outlets
**				   
*/

#include "ext.h"		// Required for all Max external objects
void *this_class;	   // Required. Global pointing to this class

typedef struct _thru	// Data structure for this object
{
	t_object t_ob;		// Must always be the first field; used by Max
	void *t_out0;		   // Pointer to outlet, need one for each outlet
	void *t_out1;		   // Pointer to outlet, need one for each outlet
	void *t_out2;		   // Pointer to outlet, need one for each outlet
	void *t_out3;		   // Pointer to outlet, need one for each outlet
	int t_val0, t_val1, t_val2, t_val3;
} t_thru;

// Prototypes for methods: you need a method for each message you want to respond to
//void *thru_new(void);				      // Object creation method
//void *thru_new(float a1, float a2, float a3, long a4);
void *thru_new(float a1, float a2, float a3);
void thru_in0(t_thru *thru, long value);	// Method for message "int" in left inlet
void thru_in1(t_thru *thru, long value);	// Method for message "int" in right inlet
void thru_in2(t_thru *thru, long value);	// Method for message "int" in right inlet
void thru_in3(t_thru *thru, long value);	// Method for message "int" in right inlet
void thru_bang(t_thru *thru);				   // Method for bang message


int main(void)			// main receives a copy of the Max function macros table
{
	// set up our class: create a class definition 
	setup((t_messlist **) &this_class, (method)thru_new, 0L, (short)sizeof(t_thru), 
			0L, A_DEFFLOAT, A_DEFFLOAT, A_DEFFLOAT,  0);
		
	addbang((method)thru_bang);	// bind method "thru_bang" to the "bang" message
	
	addint((method)thru_in0);		// bind method "thru_int" to int's received in the left inlet
	
	addinx((method)thru_in1, 1);	// bind method "thru_in1" to int's received in the right inlet
	addinx((method)thru_in2, 2);	// bind method "thru_in2" to int's received in the right inlet
	addinx((method)thru_in3, 3);	// bind method "thru_in3" to int's received in the right inlet
	return(0);
}


/**********************************************************************************
thru_new(void)

inputs:			value -- the integer from the typed argument in the object box	
description:	creates a new instance of our class thru.  Called once when the external
						object is loaded.
returns:		pointer to new instance
*************************************************************************************/
//void *thru_new(float a1, float a2, float a3, long a4)
void *thru_new(float a1, float a2, float a3)
{
	t_thru *thru;
	
	thru = (t_thru *)newobject(this_class);	// Create new instance and return a pointer to it
	
//post("A1: %f, A2: %f, A3: %f, A4: %d", a1, a2, a3, a4);	
post("A1: %f, A2: %f, A3: %f", a1, a2, a3);	
	intin(thru, 3);					// Create inlets, right-to-left 
	intin(thru, 2);					 
	intin(thru, 1);					 
	thru->t_out3 = intout(thru);	// Create outlets right-to-left 
	thru->t_out2 = intout(thru);	
	thru->t_out1 = intout(thru);	 
	thru->t_out0 = intout(thru);	
	
		
	return(thru);						// Must return a pointer to the new instance 
}
/**********************************************************************************
thru_in0(t_thru *a, long value)

inputs:			thru	- pointer to t_thru object
					value	- value received in the inlet
description:	
returns:		nothing
***********************************************************************************/

void thru_in0(t_thru *thru, long value)
{
post("Inlet 0");
	thru->t_val0 = value;	// Store the value received in the left inlet 
	outlet_int(thru->t_out0, value);
}

void thru_in1(t_thru *thru,long value)
{
post("Inlet 1");	
	thru->t_val1 = value;				// Store the value
	outlet_int(thru->t_out1, value);
}
	
void thru_in2(t_thru *thru,long value)
{	
post("Inlet 2");
	thru->t_val2 = value;				// Store the value
	outlet_int(thru->t_out2, value);
}
	
void thru_in3(t_thru *thru,long value)
{	
post("Inlet 3");
	thru->t_val3 = value;				// Store the value
	outlet_int(thru->t_out3, value);
}
	

/*************************************************************************************
thru_bang(t_thru *a)

inputs:			thru	- pointer to our object
description:	method called when bang is received: it outputs the current thruerence 
						of the left and right values
returns:		nothing
*************************************************************************************/

void thru_bang(t_thru *thru)
{
	outlet_int(thru->t_out0, 0);	
	outlet_int(thru->t_out1, 1);	
	outlet_int(thru->t_out2, 2);	
	outlet_int(thru->t_out3, 3);	
}
