/* thru~.c
** one channel thru object (a minimal MSP object)
** 99/04/05 IF
** 00/02/21 IF mono only, see thru2~ for the stereo version
** 02/10/28 IF minor updates
*/
#include "ext.h"    // Required for all Max external objects
#include "z_dsp.h"

void *thru_class;

typedef struct _thru 	// Data structure for this object
{
    t_pxobject x_obj;
} t_thru;

void *thru_new(void);
t_int *thru_perform(t_int *w);
void thru_dsp(t_thru *x, t_signal **sp, short *count);

int main(void)
{
    setup((t_messlist **)&thru_class, (method)thru_new, (method)dsp_free, (short)sizeof(t_thru), 0L, 0);
    addmess((method)thru_dsp, "dsp", A_CANT, 0);
    dsp_initclass();
	return(0);
}

void *thru_new(void)
{
	t_thru *x = (t_thru *)newobject(thru_class);
	dsp_setup((t_pxobject *)x, 1);				// left inlet
	outlet_new((t_pxobject *)x, "signal");		// left outlet
	return (x);
}


void thru_dsp(t_thru *x, t_signal **sp, short *count)
{
	post("thru~ inlet: %d outlet: %d", sp[0]->s_vec, sp[1]->s_vec);
    post("thru~ size of buffer: %d", sp[0]->s_n);
	dsp_add(thru_perform, 3, sp[0]->s_vec, sp[1]->s_vec, sp[0]->s_n);
}


t_int *thru_perform(t_int *w)
{
    t_float *inL = (t_float *)(w[1]);
    t_float *outL = (t_float *)(w[2]);
	int n = (int)(w[3]);

	while (n--) 
		*outL++ = *inL++;
		
/* the while loop above is equivalent to:
   for (i = 0; i < n; i++)
         outL[i] = inL[i];
*/
		
    return (w + 4); // always add one more than the 2nd argument in dsp_add()
}


