/* myspikeShell~.c 
** 
** Shell to get you going on writing myspike~
** spike~ reports the time interval between zero to non-zero (a spike) transition
*/


#include "ext.h"    // Required for all Max external objects
#include "z_dsp.h"  // Required for all MSP external objects

#define A_SECOND 1000.0  // Number of milliseconds in a second
void *myspike_class;

typedef struct _myspike 	// Data structure for this object
{
    t_pxobject t_obj;
    void *t_out;
    int t_count;     // temporary counter keeps track of zeros
    int t_sampcount; //the actial sample count between the first of the non-zeros and a spike
    int t_refract;
    float t_sr_sec;   // One_sec / sample_rate
} t_myspike;

void *myspike_new(void);
t_int *myspike_perform(t_int *w);
void myspike_dsp(t_myspike *x, t_signal **sp, short *count);
void myspike_free(t_myspike *x);

int main(void)
{
    setup((t_messlist **)&myspike_class, (method)myspike_new, (method)myspike_free, (short)sizeof(t_myspike), 0L, 0);
    addmess((method)myspike_dsp, "dsp", A_CANT, 0);
    dsp_initclass();	
	return(0);
}

void *myspike_new(void)
{
	t_myspike *x = (t_myspike *)newobject(myspike_class);
	dsp_setup((t_pxobject*)x, 1);			// signal inlet
	x->t_out = floatout((t_myspike *)x);
	x->t_count = 0;
	x->t_refract = 0;
	return (x);
}


void myspike_dsp(t_myspike *x, t_signal **sp, short *count)
{
	x->t_sr_sec = A_SECOND / sys_getsr();
	dsp_add(myspike_perform, 3, sp[0]->s_vec, sp[0]->s_n, x);
}

t_int *myspike_perform(t_int *w)
{
    t_float *in = (t_float *)(w[1]);
	int n = (int)(w[2]);
	t_myspike *x = (t_myspike *)w[3];
	
	while (n--) 
	{
	}
    return (w + 4); // always add one more than the 2nd argument in dsp_add()
}


