// the myallpass object
// 04/11/15 IF

#include "ext.h"
#include "z_dsp.h"

#define MAXLEN 1024

void *myallpass_class;

typedef struct _myallpass
{
	t_pxobject m_obj;
	float m_g;
	float m_delay;
	float m_buff_x[MAXLEN];
	float m_buff_y[MAXLEN];
	int m_pibuf;
	int m_pobuf;
} t_myallpass;

t_int *myallpass_perform(t_int *w);
void myallpass_dsp(t_myallpass *x, t_signal **sp, short *count);
void *myallpass_new(float delay, float a);
void myallpass_float(t_myallpass *x, float delay);
void myallpass_g(t_myallpass *x, float a);

int main(void)
{
	setup((t_messlist **)&myallpass_class, (method)myallpass_new, (method)dsp_free, 
		(short)sizeof(t_myallpass), 0L, A_DEFFLOAT, A_DEFFLOAT, 0);
	addmess((method)myallpass_dsp, "dsp", A_CANT, 0);
//   addfloat((method)myallpass_float);
   addftx((method)myallpass_g, 2);
   addftx((method)myallpass_float, 1);
   	
 	dsp_initclass();
	return(0);
}

t_int *myallpass_perform(t_int *w)
{
    t_float *in = (t_float *)(w[1]);
    t_float *out = (t_float *)(w[2]);
    t_myallpass *x = (t_myallpass *)(w[3]);
    int i, n = (int)(w[4]);
    float *buff_x = x->m_buff_x;
    float *buff_y = x->m_buff_y;
    int pibuf = x->m_pibuf;
    int pobuf = x->m_pobuf;
    
   	
    for (i = 0; i < n; i++)
    {
		buff_x[pibuf]  = in[i];
		out[i] = -x->m_g * in[i] + buff_x[pobuf] + x->m_g * buff_y[pobuf];
		buff_y[pibuf] = out[i];
		if (++pibuf >= MAXLEN)
			pibuf = 0;
		if (++pobuf >= MAXLEN)
			pobuf = 0;
    }
    x->m_pibuf = pibuf;
    x->m_pobuf = pobuf;
    
    return (w + 5);
}

void myallpass_dsp(t_myallpass *x, t_signal **sp, short *count)
{
	dsp_add(myallpass_perform, 4, sp[0]->s_vec, sp[1]->s_vec, x, sp[0]->s_n);
}

void myallpass_float(t_myallpass *x, float delay)
{
    x->m_delay = delay * sys_getsr() / 1000;  // ms to # of samples
    if (x->m_delay >= MAXLEN)
    	x->m_delay = MAXLEN - 1;
    if (x->m_delay < 0)
		x->m_delay = 0;
    	
	x->m_pobuf = x->m_pibuf - x->m_delay;
    while (x->m_pobuf < 0)
    	x->m_pobuf += MAXLEN;
post("Delay: %f in_index: %d out_index: %d", x->m_delay, x->m_pibuf, x->m_pobuf);

}

void myallpass_g(t_myallpass *x, float coeff)
{
    x->m_g = coeff; 
post("COEFF G: %f", x->m_g);
}

//void *myallpass_new(float delay, float a, float b, float c)
void *myallpass_new(float delay, float g)
{
    t_myallpass *x = (t_myallpass *)newobject(myallpass_class);
    int i;
// post("Delay %f, A: %f", delay, a);
	x->m_pibuf = 0;
    for (i = 0; i < MAXLEN; i++)
    	x->m_buff_x[i] = x->m_buff_y[i] = 0;
    dsp_setup((t_pxobject *)x, 1);
    outlet_new((t_object *)x, "signal");
    floatin(x, 2);
    floatin(x, 1);
    x->m_g = g;
    myallpass_float(x, delay);
    return (x);
}
