#include "ext.h"
#include "z_dsp.h"

// the lpfixed object. A version of the csound atone~

void *lpfixed_class;

typedef struct _lpfixed
{
	t_pxobject l_obj;
	float l_lastin;
} t_lpfixed;


t_int *lpfixed_perform(t_int *w);
void lpfixed_dsp(t_lpfixed *x, t_signal **sp, short *count);
void *lpfixed_new(double width);

int main(void)
{
	setup((t_messlist **)&lpfixed_class, (method)lpfixed_new, (method)dsp_free, 
		(short)sizeof(t_lpfixed), 0L, A_DEFFLOAT, 0);
	addmess((method)lpfixed_dsp, "dsp", A_CANT, 0);
	dsp_initclass();
	return(0);
}


// freq is a constant

t_int *lpfixed_perform(t_int *w)
{
    t_float *in = (t_float *)(w[1]);
    t_float *out = (t_float *)(w[2]);
    t_lpfixed *x = (t_lpfixed *)(w[3]);
    int n = (int)(w[4]);
    t_float val, lastin = x->l_lastin;
    
    while (n--) {
		val = *in++;
		*out++ = (val + lastin) / 2;
		lastin = val;
    }
    x->l_lastin = lastin;
    return (w + 5);
}

void lpfixed_dsp(t_lpfixed *x, t_signal **sp, short *count)
{
	x->l_lastin = 0.;
	dsp_add(lpfixed_perform, 4, sp[0]->s_vec, sp[1]->s_vec, x, sp[0]->s_n);
}


void *lpfixed_new(double val)
{
    t_lpfixed *x = (t_lpfixed *)newobject(lpfixed_class);
    dsp_setup((t_pxobject *)x, 1);
    outlet_new((t_object *)x, "signal");
    return (x);
}
