/* vario.c -- variable number of inlets and outlets ------- */
// first argument = number of outlets
// the number of other arguemts = (number of inlets - 1)
// NOTE: the inlets and outlets are created right to left.
// IF 02/10/02
// IF 03/09/30 minor change


#include "ext.h"

#define MAXSIZE 5

typedef struct vario
{
	struct object v_ob;
	void *v_out[MAXSIZE];
	long dummy;
} t_vario;


void *class;

void *vario_new(Symbol *s, short ac, t_atom *av);
void vario_in(t_vario *v, long value);

int main(void)
{
	int i;
	setup((t_messlist **)&class, (method)vario_new, 0L, (short)sizeof(t_vario), 
			0L, A_GIMME, 0);
	for (i = 0; i < MAXSIZE; i++)	
		addinx((method)vario_in, i + 1);
	return(0);
}


void vario_in(t_vario *v, long value)
{
	v->dummy = value;
}

void *vario_new(Symbol *s, short ac, t_atom *av)
{
	t_vario *x;
	long n_outlets, n_inlets;
	int i;
	
	x = (t_vario *)newobject(class);
	if (ac) 
	{
			n_outlets = av->a_w.w_long;
			if (n_outlets > 0)
			{
				if (n_outlets > MAXSIZE)
					n_outlets = MAXSIZE;
				for (i = 0; i < n_outlets; i++)
					x->v_out[i] = intout(x);
			}
			n_inlets = (ac > MAXSIZE) ? MAXSIZE: ac;
			for (i = 0; i < n_inlets - 1; i++)
					intin(x, i + 1);	
post("Inlet : %d", n_inlets);
post("Outlet: %d", n_outlets);
	} 
	return (x);
}
