// Karplus Strong w/o the filter
#include "ext.h"
#include "z_dsp.h"

#define MAXSIZE 4096
#define RANDMAX 32768

void *noise1_class;

typedef struct _noise1
{
	t_pxobject h_obj;
	t_float buf[MAXSIZE];
	int index;
	int size;
} t_noise1;

t_int *noise11_perform(t_int *w);
void noise1_dsp(t_noise1 *x, t_signal **sp, short *count);
void noise1_float(t_noise1 *x, double f);
void *noise1_new(double width);
void ks_bang(t_noise1 *x);

int main(void)
{
	setup((t_messlist **)&noise1_class, (method)noise1_new, (method)dsp_free, 
		(short)sizeof(t_noise1), 0L, A_DEFFLOAT, 0);
	addmess((method)noise1_dsp, "dsp", A_CANT, 0);
	addfloat((method)noise1_float);
	addbang((method)ks_bang);
	dsp_initclass();
	return(0);
}


t_int *noise11_perform(t_int *w)
{
    t_noise1 *x = (t_noise1 *)(w[1]);
    t_float *out = (t_float *)(w[2]);
    int n = (int)(w[3]);    
	
    while (n--)
    {
      *out++ = x->buf[x->index];
      if (x->index++ >= x->size)
        x->index = 0;
    }
    return (w + 4);
}

void noise1_dsp(t_noise1 *x, t_signal **sp, short *count)
{
	dsp_add(noise11_perform, 3, x, sp[1]->s_vec, sp[1]->s_n);
}

void noise1_float(t_noise1 *x, double f)
{
	int size = sys_getsr() / f + 0.5;
//post("Size: %d", size);
	x->size = (size > MAXSIZE) ? MAXSIZE : size;
}

void ks_bang(t_noise1 *x)
{
    int i;
    x->index = 0;
    for (i = 0; i < x->size; i++)
      x->buf[i] = (float)Random() / RANDMAX;   
}


void *noise1_new(double val)
{
    t_noise1 *x = (t_noise1 *)newobject(noise1_class);
    int i;
    
    dsp_setup((t_pxobject *)x, 1);
    outlet_new((t_object *)x, "signal");
    for (i = 0; i < MAXSIZE; i++)
      x->buf[i] = 0;
    x->index = 0;
    noise1_float(x, val);
    return (x);
}
